﻿using System;
using System.Collections.Generic;
using System.ServiceModel.DomainServices.Client;
using System.Windows;
using System.Windows.Controls;
using AlbumsCatalog.Web;

namespace AlbumsCatalog
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            Loaded += new RoutedEventHandler(MainPage_Loaded);
        }

        // Abschluss des Ladevorgangs dieser Ansicht...
        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
        }


        private void artistDomainDataSource_LoadedData(object sender, System.Windows.Controls.LoadedDataEventArgs e)
        {

            if (e.HasError)
            {
                System.Windows.MessageBox.Show(e.Error.ToString(), "Load Error", System.Windows.MessageBoxButton.OK);
                e.MarkErrorAsHandled();
            }
        }

        private void trackDomainDataSource_LoadedData(object sender, LoadedDataEventArgs e)
        {

            if (e.HasError)
            {
                System.Windows.MessageBox.Show(e.Error.ToString(), "Load Error", System.Windows.MessageBoxButton.OK);
                e.MarkErrorAsHandled();
            }
        }

        private void addButton_Click(object sender, RoutedEventArgs e)
        {
            // Erzeuge einen neuen Track
            var newTrack = new Track();
            newTrack.Name = "<Neu>";
            // Stelle sicher, zu welchem Album der Track gehört
            newTrack.AlbumId = (albumsComboBox.SelectedItem as Album).AlbumId;
            // Füge Track hinzu
            trackDomainDataSource.DataView.Add(newTrack);
        }

        private void deleteButton_Click(object sender, RoutedEventArgs e)
        {
            // Ermittle den aktuell gewählten Track
            var currentTrack = trackDataGrid.SelectedItem as Track;
            if (currentTrack != null)
            {
                // Entferne den aktuellen Track
                trackDomainDataSource.DataView.Remove(currentTrack);
            }
        }
    }
}